/*
 * Decompiled with CFR 0.152.
 */
package com.github.mammut53.more_babies.config;

import com.github.mammut53.more_babies.MoreBabiesConstants;
import java.util.HashMap;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MoreBabiesConfig {
    public static final ForgeConfigSpec SPEC;
    public static final MoreBabiesConfig CONFIG;
    public static HashMap<String, BabyEntry> BABIES;

    private MoreBabiesConfig(ForgeConfigSpec.Builder builder) {
        BABIES = new HashMap();
        builder.push("general");
        builder.pop();
        builder.push("babies");
        for (String baby : MoreBabiesConstants.BABY_IDS) {
            builder.push(baby);
            BabyScSmEntry babyEntry = switch (baby) {
                case "blaze", "cave_spider" -> new BabyScSmRsEntry(builder);
                case "creeper" -> new BabyScSmErEntry(builder);
                default -> new BabyScSmEntry(builder);
            };
            BABIES.put(baby, babyEntry);
            builder.pop();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(MoreBabiesConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (MoreBabiesConfig)specPair.getLeft();
    }

    public static class BabyScSmRsEntry
    extends BabyScSmEntry
    implements BabyReplaceSpawners {
        public final BabyReplaceSpawnersEntry babyReplaceSpawnersEntry;

        public BabyScSmRsEntry(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.babyReplaceSpawnersEntry = new BabyReplaceSpawnersEntry(builder);
        }

        @Override
        public ForgeConfigSpec.BooleanValue getReplaceSpawners() {
            return this.babyReplaceSpawnersEntry.getReplaceSpawners();
        }
    }

    public static class BabyScSmErEntry
    extends BabyScSmEntry
    implements BabyExplosionRadius {
        public final BabyExplosionRadiusEntry babyExplosionRadiusEntry;

        public BabyScSmErEntry(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.babyExplosionRadiusEntry = new BabyExplosionRadiusEntry(builder);
        }

        @Override
        public ForgeConfigSpec.IntValue getExplosionRadius() {
            return this.babyExplosionRadiusEntry.getExplosionRadius();
        }
    }

    public static class BabyScSmEntry
    implements BabySpawnChance,
    BabySpeedModifier {
        public final BabySpawnChanceEntry babySpawnChance;
        public final BabySpeedModifierEntry babySpeedModifier;

        public BabyScSmEntry(ForgeConfigSpec.Builder builder) {
            this.babySpawnChance = new BabySpawnChanceEntry(builder);
            this.babySpeedModifier = new BabySpeedModifierEntry(builder);
        }

        @Override
        public ForgeConfigSpec.DoubleValue getSpawnChance() {
            return this.babySpawnChance.getSpawnChance();
        }

        @Override
        public ForgeConfigSpec.DoubleValue getSpeedModifier() {
            return this.babySpeedModifier.getSpeedModifier();
        }
    }

    public static class BabyReplaceSpawnersEntry
    implements BabyReplaceSpawners {
        public final ForgeConfigSpec.BooleanValue replaceSpawners;

        public BabyReplaceSpawnersEntry(ForgeConfigSpec.Builder builder) {
            this.replaceSpawners = builder.comment("If spawners in structures should be replaced with baby spawners based on the defined spawn weight").define("replaceSpawners", true);
        }

        @Override
        public ForgeConfigSpec.BooleanValue getReplaceSpawners() {
            return this.replaceSpawners;
        }
    }

    public static class BabyExplosionRadiusEntry
    implements BabyExplosionRadius {
        public final ForgeConfigSpec.IntValue explosionRadius;

        public BabyExplosionRadiusEntry(ForgeConfigSpec.Builder builder) {
            this.explosionRadius = builder.comment("Explosion radius (reference values: creeper = 3, TNT = 4)").defineInRange("explosionRadius", 2, 0, 100);
        }

        @Override
        public ForgeConfigSpec.IntValue getExplosionRadius() {
            return this.explosionRadius;
        }
    }

    public static class BabySpeedModifierEntry
    implements BabySpeedModifier {
        public final ForgeConfigSpec.DoubleValue speedModifier;

        public BabySpeedModifierEntry(ForgeConfigSpec.Builder builder) {
            this.speedModifier = builder.comment("Speed of baby compared to normal mob (is only set on initial spawn)").worldRestart().defineInRange("speedModifier", 1.5, 0.0, 2.0);
        }

        @Override
        public ForgeConfigSpec.DoubleValue getSpeedModifier() {
            return this.speedModifier;
        }
    }

    public static class BabySpawnChanceEntry
    implements BabySpawnChance {
        public final ForgeConfigSpec.DoubleValue spawnChance;

        public BabySpawnChanceEntry(ForgeConfigSpec.Builder builder) {
            this.spawnChance = builder.comment("Percentage of mobs that will be replaced with babies").defineInRange("spawnChance", 0.05, 0.0, 1.0);
        }

        @Override
        public ForgeConfigSpec.DoubleValue getSpawnChance() {
            return this.spawnChance;
        }
    }

    public static interface BabyReplaceSpawners
    extends BabyEntry {
        public ForgeConfigSpec.BooleanValue getReplaceSpawners();
    }

    public static interface BabyExplosionRadius
    extends BabyEntry {
        public ForgeConfigSpec.IntValue getExplosionRadius();
    }

    public static interface BabySpeedModifier
    extends BabyEntry {
        public ForgeConfigSpec.DoubleValue getSpeedModifier();
    }

    public static interface BabySpawnChance
    extends BabyEntry {
        public ForgeConfigSpec.DoubleValue getSpawnChance();
    }

    public static interface BabyEntry {
    }
}

